clear
cd "/Users/Wei/Desktop"
set more off

*=======================================
*    Nominal industrial GDP (no groups)
*=======================================

use "Data for Statistical Model.dta"

drop ngdp* 

reshape long ind light ntax expor impor ecos rail exch, i(code0) j(year)
sort code0 year

* Exchange USD to RMB
replace expor=expor*exch/100
replace impor=impor*exch/100


* Use nominal value added of indsutry
rename ind ngdp


xtset code0 year

gen log_ngdp = log(ngdp)
gen log_light = log(light)
gen log_ntax = log(ntax)
gen log_expor=log(expor)
gen log_impor=log(impor)
gen log_ecos = log(ecos)
gen log_rail = log(rail)


gen ngdpg=log_ngdp-l.log_ngdp
gen lightg=log_light-l.log_light
gen ntaxg=log_ntax-l.log_ntax
gen exporg=log_expor-l.log_expor
gen imporg=log_impor-l.log_impor
gen ecosg=log_ecos-l.log_ecos
gen railg=log_rail-l.log_rail


* Regression for 2000-2007 with light
eststo clear

xtreg log_ngdp log_light log_ntax log_expor log_impor log_ecos log_rail if year>1999 & year<2008, fe r
eststo

gen coef_light = _b[log_light]
gen coef_ntax = _b[log_ntax]
gen coef_expor = _b[log_expor]
gen coef_impor = _b[log_impor]
gen coef_ecos = _b[log_ecos]
gen coef_rail = _b[log_rail]

gen ngdpg0113 = coef_light * lightg + coef_ntax * ntaxg  + coef_expor * exporg + coef_impor * imporg + coef_ecos * ecosg + coef_rail * railg


* Regression for 2000-2007 without light
xtreg log_ngdp log_ntax log_expor log_impor log_ecos log_rail if year>1999 & year<2008, fe r
eststo

replace coef_ntax = _b[log_ntax]
replace coef_expor = _b[log_expor]
replace coef_impor = _b[log_impor]
replace coef_ecos = _b[log_ecos]
replace coef_rail = _b[log_rail]

gen ngdpg0115 = coef_ntax * ntaxg  + coef_expor * exporg + coef_impor * imporg + coef_ecos * ecosg + coef_rail * railg


* Regression for 2000-2007 without light & tax
xtreg log_ngdp log_expor log_impor log_ecos log_rail if year>1999 & year<2008, fe r
eststo

replace coef_expor = _b[log_expor]
replace coef_impor = _b[log_impor]
replace coef_ecos = _b[log_ecos]
replace coef_rail = _b[log_rail]

gen ngdpg0117 = coef_expor * exporg + coef_impor * imporg + coef_ecos * ecosg + coef_rail * railg

esttab est* using reg_nogroup_ind_n.rtf,se r2 star(* 0.1 ** 0.05 *** 0.01) replace
   

* Estimated provincial sum (benchmark year 2009)
forvalues t=13(2)17 {
gen log_ngdp_est01`t'=log_ngdp if year==2009
replace log_ngdp_est01`t'=l.log_ngdp_est01`t'+ngdpg01`t' if year>2009
forvalues i=2000(1)2008 {
local j=`i'-2000
local k=2008-`j'
replace log_ngdp_est01`t'=f.log_ngdp_est01`t'-f.ngdpg01`t' if year==`k'
}
gen ngdp_est01`t'=exp(log_ngdp_est01`t')
}


outsheet ngdp_est0115 ngdp_est0117 if year==2015 using "est_nogroup_ind_n_2015.csv", c replace

* Get provincial sum (level)
collapse (sum)ngdp_est0113 (sum)ngdp_est0115 (sum)ngdp_est0117,by(year)
keep if year>1999
outsheet ngdp_est0113 ngdp_est0115 ngdp_est0117 using "est_nogroup_ind_n.csv", c replace

eststo clear



*=======================================
*    Nominal Total GDP C-Lasso
*=======================================

clear

* Import group information
insheet using "Group from CLasso (with light)_nominal.csv",clear
rename v1 code0
rename v2 group1
rename v3 group2
save "Group from CLasso (with light)_nominal.dta",replace

insheet using "Group from CLasso (no light)_nominal.csv",clear
rename v1 code0
rename v2 group2
rename v3 group1
save "Group from CLasso (no light)_nominal.dta",replace

insheet using "Group from CLasso (no light tax)_nominal.csv",clear
rename v1 code0
rename v2 group1
rename v3 group2
save "Group from CLasso (no light tax)_nominal.dta",replace

use "Data for Statistical Model.dta"

drop ind* rail*

reshape long ngdp light ntax expor impor ecos exch, i(code0) j(year)
sort code0 year

* Exchange USD to RMB
replace expor=expor*exch/100
replace impor=impor*exch/100

gen log_ngdp = log(ngdp)
gen log_light = log(light)
gen log_ntax = log(ntax)
gen log_expor=log(expor)
gen log_impor=log(impor)
gen log_ecos = log(ecos)

xtset code0 year

gen ngdpg=log_ngdp-l.log_ngdp
gen lightg=log_light-l.log_light
gen ntaxg=log_ntax-l.log_ntax
gen exporg=log_expor-l.log_expor
gen imporg=log_impor-l.log_impor
gen ecosg=log_ecos-l.log_ecos


* Regression for 2000-2007 with light
merge m:m code0 using "Group from CLasso (with light)_nominal.dta"
drop _merge

eststo clear

xtreg log_ngdp log_light log_ntax log_expor log_impor log_ecos if year>1999 & year<2008 & group1==1, fe r
eststo

gen coef_light = _b[log_light]
gen coef_ntax = _b[log_ntax]
gen coef_expor = _b[log_expor]
gen coef_impor = _b[log_impor]
gen coef_ecos = _b[log_ecos]


xtreg log_ngdp log_light log_ntax log_expor log_impor log_ecos  if year>1999 & year<2008 & group2==1, fe r
eststo

gen coef2_light = _b[log_light]
gen coef2_ntax = _b[log_ntax]
gen coef2_expor = _b[log_expor]
gen coef2_impor = _b[log_impor]
gen coef2_ecos = _b[log_ecos]

gen ngdpg0113 = coef_light * lightg + coef_ntax * ntaxg  + coef_expor * exporg + coef_impor * imporg + coef_ecos * ecosg   if group1==1
replace ngdpg0113=coef2_light * lightg + coef2_ntax * ntaxg  + coef2_expor * exporg + coef2_impor * imporg + coef2_ecos * ecosg if group2==1


* Regressions for 2000-2007 without light
drop group1 group2

merge m:m code0 using "Group from CLasso (no light)_nominal.dta"
drop _merge
			 
xtset code0 year

xtreg log_ngdp log_ntax log_expor log_impor log_ecos if year>1999 & year<2008 & group1==1, fe r
eststo

replace coef_ntax = _b[log_ntax]
replace coef_expor = _b[log_expor]
replace coef_impor = _b[log_impor]
replace coef_ecos = _b[log_ecos]

xtreg log_ngdp log_ntax log_expor log_impor log_ecos  if year>1999 & year<2008 & group2==1, fe r
eststo

replace coef2_ntax = _b[log_ntax]
replace coef2_expor = _b[log_expor]
replace coef2_impor = _b[log_impor]
replace coef2_ecos = _b[log_ecos]


gen ngdpg0115= coef_ntax * ntaxg  + coef_expor * exporg + coef_impor * imporg + coef_ecos * ecosg if group1==1
replace ngdpg0115= coef2_ntax * ntaxg  + coef2_expor * exporg + coef2_impor * imporg + coef2_ecos * ecosg if group2==1


* Regression for 2000-2007 without light tax
drop group1 group2

merge m:m code0 using "Group from CLasso (no light tax)_nominal.dta"
drop _merge
			 
xtset code0 year

xtreg log_ngdp log_expor log_impor log_ecos if year>1999 & year<2008 & group1==1, fe r
eststo

replace coef_expor = _b[log_expor]
replace coef_impor = _b[log_impor]
replace coef_ecos = _b[log_ecos]


xtreg log_ngdp log_expor log_impor log_ecos  if year>1999 & year<2008 & group2==1, fe r
eststo

replace coef2_expor = _b[log_expor]
replace coef2_impor = _b[log_impor]
replace coef2_ecos = _b[log_ecos]

gen ngdpg0117= coef_expor * exporg + coef_impor * imporg + coef_ecos * ecosg if group1==1
replace ngdpg0117= coef2_expor * exporg + coef2_impor * imporg + coef2_ecos * ecosg if group2==1

esttab est* using reg_group_n.rtf,se r2 star(* 0.1 ** 0.05 *** 0.01) ///
                                        mtitles("Group 1" "Group 2" "Group 1" "Group 2" "Group 1" "Group 2") replace


* Estimated provincial sum (benchmark year 2009)
xtset code0 year

forvalues t=13(2)17 {
gen log_ngdp_est01`t'=log_ngdp if year==2009
replace log_ngdp_est01`t'=l.log_ngdp_est01`t'+ngdpg01`t' if year>2009
forvalues i=2000(1)2008 {
local j=`i'-2000
local k=2008-`j'
replace log_ngdp_est01`t'=f.log_ngdp_est01`t'-f.ngdpg01`t' if year==`k'
}
gen ngdp_est01`t'=exp(log_ngdp_est01`t')
}

outsheet ngdp_est0115 ngdp_est0117 if year==2015 using "est_group_n_2015.csv", c replace


* Get provincial sum (level)
collapse (sum)ngdp_est0113 (sum)ngdp_est0115 (sum)ngdp_est0117,by(year)
keep if year>1999
outsheet ngdp_est0113 ngdp_est0115 ngdp_est0117 using "est_group_n.csv", c replace

eststo clear
